/**
 * Wrap an instance of the browser's local or session storage to handle
 * cache expiry, key namespacing and other helpful things.
 *
 * @module     core/storagewrapper
 * @copyright  2017 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("core/storagewrapper",["core/config"],(function(config){var Wrapper=function(storage){this.storage=storage,this.supported=this.detectSupport(),this.hashSource=config.wwwroot+"/"+config.jsrev,this.hash=this.hashString(this.hashSource),this.prefix=this.hash+"/",this.jsrevPrefix=this.hashString(config.wwwroot)+"/jsrev",this.validateCache()};return Wrapper.prototype.detectSupport=function(){if(-1==config.jsrev)return!1;if(void 0===this.storage)return!1;try{return null!==this.storage&&(this.storage.setItem("test","1"),this.storage.removeItem("test"),!0)}catch(ex){return!1}},Wrapper.prototype.prefixKey=function(key){return this.prefix+key},Wrapper.prototype.validateCache=function(){if(this.supported){var cacheVersion=this.storage.getItem(this.jsrevPrefix);if(null!==cacheVersion)config.jsrev!=cacheVersion&&(this.storage.clear(),this.storage.setItem(this.jsrevPrefix,config.jsrev));else this.storage.setItem(this.jsrevPrefix,config.jsrev)}},Wrapper.prototype.hashString=function(source){var i,len,hash=0;if(0===source.length)return hash;for(i=0,len=source.length;i<len;i++)hash=(hash<<5)-hash+source.charCodeAt(i),hash|=0;return hash},Wrapper.prototype.get=function(key){return!!this.supported&&(key=this.prefixKey(key),this.storage.getItem(key))},Wrapper.prototype.set=function(key,value){if(!this.supported)return!1;key=this.prefixKey(key);try{this.storage.setItem(key,value)}catch(e){return!1}return!0},Wrapper}));

//# sourceMappingURL=storagewrapper.min.js.map