/**
 * Module for viewing a discussion.
 *
 * @module     mod_forum/discussion_list
 * @copyright  2019 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("mod_forum/discussion",["jquery","core/custom_interaction_events","mod_forum/selectors","core/pubsub","mod_forum/forum_events","core/str","core/notification"],(function($,CustomEvents,Selectors,PubSub,ForumEvents,String,Notification){var isElementInInPageReplySection=function(element){return!!$(element).closest(Selectors.post.inpageReplyContent).length},initAccessibilityKeyboardNav=function(root){root.find(Selectors.post.post).each((function(index,post){var actions=$(post).find(Selectors.post.action),firstAction=actions.first();actions.attr("tabindex","-1"),firstAction.attr("tabindex",0)})),CustomEvents.define(root,[CustomEvents.events.up,CustomEvents.events.down,CustomEvents.events.next,CustomEvents.events.previous,CustomEvents.events.home,CustomEvents.events.end]),root.on(CustomEvents.events.up,(function(e,data){var activeElement=document.activeElement;if(!isElementInInPageReplySection(activeElement)){var focusPost=$(activeElement).closest(Selectors.post.post);focusPost.length?function(currentPost){var prevPost=currentPost.prev(Selectors.post.post);if(prevPost.length){var replyPost=prevPost.find(Selectors.post.post).last();replyPost.length?replyPost.focus():prevPost.focus()}else currentPost.parents(Selectors.post.post).first().focus()}(focusPost):root.find(Selectors.post.post).first().focus(),data.originalEvent.preventDefault()}})),root.on(CustomEvents.events.down,(function(e,data){var activeElement=document.activeElement;if(!isElementInInPageReplySection(activeElement)){var focusPost=$(activeElement).closest(Selectors.post.post);focusPost.length?function(currentPost){var replyPost=currentPost.find(Selectors.post.post).first();if(replyPost.length)replyPost.focus();else{var siblingPost=currentPost.next(Selectors.post.post);if(siblingPost.length)siblingPost.focus();else for(var parentPosts=currentPost.parents(Selectors.post.post).toArray(),i=0;i<parentPosts.length;i++){var ancestorSiblingPost=$(parentPosts[i]).next(Selectors.post.post);if(ancestorSiblingPost.length){ancestorSiblingPost.focus();break}}}}(focusPost):root.find(Selectors.post.post).first().focus(),data.originalEvent.preventDefault()}})),root.on(CustomEvents.events.home,(function(e,data){isElementInInPageReplySection(document.activeElement)||(root.find(Selectors.post.post).first().focus(),data.originalEvent.preventDefault())})),root.on(CustomEvents.events.end,(function(e,data){isElementInInPageReplySection(document.activeElement)||(root.find(Selectors.post.post).last().focus(),data.originalEvent.preventDefault())})),root.on(CustomEvents.events.next,Selectors.post.action,(function(e,data){var currentAction=$(e.target),actions=currentAction.closest(Selectors.post.actionsContainer).find(Selectors.post.action),nextAction=currentAction.next(Selectors.post.action);actions.attr("tabindex","-1"),nextAction.length||(nextAction=actions.first()),nextAction.attr("tabindex",0),nextAction.focus(),data.originalEvent.preventDefault()})),root.on(CustomEvents.events.previous,Selectors.post.action,(function(e,data){var currentAction=$(e.target),actions=currentAction.closest(Selectors.post.actionsContainer).find(Selectors.post.action),nextAction=currentAction.prev(Selectors.post.action);actions.attr("tabindex","-1"),nextAction.length||(nextAction=actions.last()),nextAction.attr("tabindex",0),nextAction.focus(),data.originalEvent.preventDefault()})),root.on(CustomEvents.events.home,Selectors.post.action,(function(e,data){var actions=$(e.target).closest(Selectors.post.actionsContainer).find(Selectors.post.action),firstAction=actions.first();actions.attr("tabindex","-1"),firstAction.attr("tabindex",0),firstAction.focus(),e.stopPropagation(),data.originalEvent.preventDefault()})),root.on(CustomEvents.events.end,Selectors.post.action,(function(e,data){var actions=$(e.target).closest(Selectors.post.actionsContainer).find(Selectors.post.action),lastAction=actions.last();actions.attr("tabindex","-1"),lastAction.attr("tabindex",0),lastAction.focus(),e.stopPropagation(),data.originalEvent.preventDefault()})),PubSub.subscribe(ForumEvents.SUBSCRIPTION_TOGGLED,(function(data){var updateMessage=data.subscriptionState?"discussionsubscribed":"discussionunsubscribed";String.get_string(updateMessage,"forum").then((function(s){return Notification.addNotification({message:s,type:"info"})})).catch(Notification.exception)}))};return{init:function(root){initAccessibilityKeyboardNav(root)}}}));

//# sourceMappingURL=discussion.min.js.map